proc tabulate data = ghpb19;
class health_only ent3 INS3 filingsize / PRELOADFMT;
var subtl_act_rtd_sep_CNE tot_assets_eoy_AME tot_liabilities_eoy_AME / WEIGHT=DUP_WGT;
VAR DUP_WGT;

title 'Table A2. Number of Group Health Plans, Total Participants, Assets, and Liabilities';
title2 'by type of insurance and type of plan, 2019';
title3 'All Plans';
table (DUP_WGT='Number of Plans'*sum=' '*f=comma12. subtl_act_rtd_sep_CNE='Participants, End of Year (thousands)'*sum=' '*f=k12f. tot_assets_eoy_AME='Assets (millions)'*sum=' '*f=m12f_2stars.
tot_liabilities_eoy_AME='Liabilities (millions)'*sum=' '*f=m12f_2stars.)*(all='Total' health_only=' '), (all='All Plans' INS3=' ')*(all='Total' ent3=' ')
/ Box='Summary Statistics by Type of Benefit' MISSTEXT='-';
run;

proc tabulate data = ghpb19;
class health_only ent3 INS3 filingsize / PRELOADFMT;
var subtl_act_rtd_sep_CNE tot_assets_eoy_AME tot_liabilities_eoy_AME / WEIGHT=DUP_WGT;
WHERE FILINGSIZE='1';
VAR DUP_WGT;
title 'Table A2. Number of Group Health Plans, Total Participants, Assets, and Liabilities';
title2 'by type of insurance and type of plan, 2019';
title3 'Plans with 100 or More Participants and Trusts';
table (DUP_WGT='Number of Plans'*sum=' '*f=comma12. subtl_act_rtd_sep_CNE='Participants, End of Year (thousands)'*sum=' '*f=k12f. tot_assets_eoy_AME='Assets (millions)'*sum=' '*f=m12f_2stars.
tot_liabilities_eoy_AME='Liabilities (millions)'*sum=' '*f=m12f_2stars.)*(all='Total' health_only=' '), (all='All Plans' INS3=' ')*(all='Total' ent3=' ')
/ Box='Summary Statistics by Type of Benefit' MISSTEXT='-';
run;

proc tabulate data = ghpb19;
class health_only ent3 INS3 filingsize / PRELOADFMT;
var subtl_act_rtd_sep_CNE tot_assets_eoy_AME tot_liabilities_eoy_AME / WEIGHT=DUP_WGT;
WHERE FILINGSIZE='2';
VAR DUP_WGT;
title 'Table A2. Number of Group Health Plans, Total Participants, Assets, and Liabilities';
title2 'by type of insurance and type of plan, 2019';
title3 'Plans with 100 or More Participants and No Trusts';
table (DUP_WGT='Number of Plans'*sum=' '*f=comma12. subtl_act_rtd_sep_CNE='Participants, End of Year (thousands)'*sum=' '*f=k12f. tot_assets_eoy_AME='Assets (millions)'*sum=' '*f=m12f_2stars.
tot_liabilities_eoy_AME='Liabilities (millions)'*sum=' '*f=m12f_2stars.)*(all='Total' health_only=' '), (all='All Plans' INS3=' ')*(all='Total' ent3=' ')
/ Box='Summary Statistics by Type of Benefit' MISSTEXT='-';
run;

proc tabulate data = ghpb19;
class health_only ent3 INS3 filingsize / PRELOADFMT;
var subtl_act_rtd_sep_CNE tot_assets_eoy_AME tot_liabilities_eoy_AME / WEIGHT=DUP_WGT;
WHERE FILINGSIZE='3';
VAR DUP_WGT;
title 'Table A2. Number of Group Health Plans, Total Participants, Assets, and Liabilities';
title2 'by type of insurance and type of plan, 2019';
title3 'Plans with Fewer Than 100 Participants and Trusts';
table (DUP_WGT='Number of Plans'*sum=' '*f=comma12. subtl_act_rtd_sep_CNE='Participants, End of Year (thousands)'*sum=' '*f=k12f. tot_assets_eoy_AME='Assets (millions)'*sum=' '*f=m12f_2stars.
tot_liabilities_eoy_AME='Liabilities (millions)'*sum=' '*f=m12f_2stars.)*(all='Total' health_only=' '), (all='All Plans' INS3=' ')*(all='Total' ent3=' ')
/ Box='Summary Statistics by Type of Benefit' MISSTEXT='-';
run;
